#include "Bush.h"



Bush::Bush()
{
	setCollider(false);	//A bush is a decorative item so we do not collide with it
}


Bush::~Bush()
{
}

void Bush::create(SpriteSize size)
{
	spriteSize = size;
	spriteType = SpriteType::BushSprite;

	switch (spriteSize)
	{
	case SpriteSize::Small:
		spriteTexture.loadFromFile("Assets/Sprites/Game Items/Bush/small.png");	//Load the small texture
		setSize(sf::Vector2f(109, 55));	//Set its size to the small size
		break;

	case SpriteSize::Medium:
		spriteTexture.loadFromFile("Assets/Sprites/Game Items/Bush/medium.png");	//Load the medium texture
		setSize(sf::Vector2f(163, 55));	//Set its size to the medium size
		break;

	case SpriteSize::Big:
		spriteTexture.loadFromFile("Assets/Sprites/Game Items/Bush/big.png");	//Load the big texture
		setSize(sf::Vector2f(219, 55));	//Set its size to the big size
		break;
	}

	setTexture(&spriteTexture);
}
